/*
 * Decompiled with CFR 0.152.
 */
package com.tableau.hyperapi;

import com.sun.jna.Pointer;
import com.tableau.hyperapi.HyperAPI;
import com.tableau.hyperapi.HyperException;
import com.tableau.hyperapi.Inserter;
import com.tableau.hyperapi.Name;
import com.tableau.hyperapi.NativeHandleHelpers;
import com.tableau.hyperapi.Nullability;
import com.tableau.hyperapi.Persistence;
import com.tableau.hyperapi.SqlType;
import com.tableau.hyperapi.TableName;
import com.tableau.hyperapi.TypeTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

public final class TableDefinition {
    private TableName tableName;
    private List<Column> columns;
    private Persistence persistence;

    public TableDefinition(TableName tableName, List<Column> columns, Persistence persistence) {
        this.tableName = tableName;
        this.columns = columns;
        this.persistence = persistence;
    }

    public TableDefinition(TableName tableName, List<Column> columns) {
        this(tableName, columns, Persistence.PERMANENT);
    }

    public TableDefinition(TableName tableName, Persistence persistence) {
        this(tableName, new ArrayList<Column>(), persistence);
    }

    public TableDefinition(TableName tableName) {
        this(tableName, new ArrayList<Column>(), Persistence.PERMANENT);
    }

    static TableDefinition constructFromNativeHandle(Pointer handle) {
        NativeHandleHelpers.assertHandleNotNull(handle);
        String dbName = HyperAPI.hyper_table_definition_database_name(handle);
        String schemaName = HyperAPI.hyper_table_definition_schema_name(handle);
        String tableName = HyperAPI.hyper_table_definition_table_name(handle);
        TableName name = dbName == null || dbName.isEmpty() ? (schemaName == null || schemaName.isEmpty() ? new TableName(tableName) : new TableName(schemaName, tableName)) : new TableName(dbName, schemaName, tableName);
        Persistence persistence = Persistence.valueOf(HyperAPI.hyper_table_definition_table_persistence(handle));
        return new TableDefinition(name, TableDefinition.getColumnsFromNativeHandle(handle), persistence);
    }

    static List<Column> getColumnsFromNativeHandle(Pointer handle) {
        int columnCount = HyperAPI.hyper_table_definition_column_count(handle);
        ArrayList<Column> columns = new ArrayList<Column>(columnCount);
        for (int position = 0; position < columnCount; ++position) {
            String name = HyperAPI.hyper_table_definition_column_name(handle, position);
            SqlType type = new SqlType(handle, position);
            String collation = HyperAPI.hyper_table_definition_column_collation(handle, position);
            boolean nullable = HyperAPI.hyper_table_definition_column_is_nullable(handle, position);
            Nullability nullability = nullable ? Nullability.NULLABLE : Nullability.NOT_NULLABLE;
            Column column = new Column(name, type, collation, nullability);
            columns.add(column);
        }
        return columns;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    TableDefinition getSubset(String[] columnSubset) {
        TableDefinition result = new TableDefinition(this.tableName, this.getPersistence());
        for (String columnName : columnSubset) {
            result.addColumn(this.getColumnByName(columnName).orElseThrow(() -> new IllegalArgumentException("There is no column named " + columnName)));
        }
        return result;
    }

    TableDefinition getSubset(List<Inserter.ColumnMapping> columnMappings) {
        TableDefinition result = new TableDefinition(this.tableName, this.getPersistence());
        for (Inserter.ColumnMapping columnMapping : columnMappings) {
            result.addColumn(this.getColumnByName(columnMapping.getColumnName()).orElseThrow(() -> new IllegalArgumentException("There is no column named " + columnMapping.getColumnName())));
        }
        return result;
    }

    public Column getColumn(int position) {
        return this.columns.get(position);
    }

    public Optional<Column> getColumnByName(String columnName) {
        return this.getColumnByName(new Name(columnName));
    }

    public Optional<Column> getColumnByName(Name columnName) {
        for (Column column : this.columns) {
            if (!column.name.equals(columnName)) continue;
            return Optional.of(column);
        }
        return Optional.empty();
    }

    public OptionalInt getColumnPositionByName(String columnName) {
        return this.getColumnPositionByName(new Name(columnName));
    }

    public OptionalInt getColumnPositionByName(Name columnName) {
        for (int position = 0; position < this.columns.size(); ++position) {
            if (!this.columns.get(position).name.equals(columnName)) continue;
            return OptionalInt.of(position);
        }
        return OptionalInt.empty();
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public TableDefinition setTableName(TableName tableName) {
        this.tableName = tableName;
        return this;
    }

    public Persistence getPersistence() {
        return this.persistence;
    }

    public TableDefinition setPersistence(Persistence persistence) {
        this.persistence = persistence;
        return this;
    }

    public TableDefinition addColumn(Column column) {
        this.columns.add(column);
        return this;
    }

    public TableDefinition addColumn(String columnName, SqlType type, String collation, Nullability nullability) {
        this.columns.add(new Column(columnName, type, collation, nullability));
        return this;
    }

    public TableDefinition addColumn(String columnName, SqlType type, String collation) {
        this.columns.add(new Column(columnName, type, collation));
        return this;
    }

    public TableDefinition addColumn(String columnName, SqlType type, Nullability nullability) {
        this.columns.add(new Column(columnName, type, nullability));
        return this;
    }

    public TableDefinition addColumn(String columnName, SqlType type) {
        this.columns.add(new Column(columnName, type));
        return this;
    }

    Pointer createNativeTableDefinition() {
        Pointer schemaHandle = HyperAPI.hyper_create_table_definition(this.tableName.getDatabaseNameOrNull(), this.tableName.getSchemaNameOrNull(), this.tableName.getName().getUnescaped(), this.persistence.getValue(), false);
        if (schemaHandle == null) {
            throw new OutOfMemoryError();
        }
        for (Column column : this.columns) {
            Pointer error = HyperAPI.hyper_table_definition_add_column(schemaHandle, column.name.getUnescaped(), column.type.getTag().getValue(), column.type.getInternalTypeModifier().orElse(-1), column.collation, column.nullability == Nullability.NULLABLE);
            if (error == null) continue;
            HyperAPI.hyper_destroy_table_definition(schemaHandle);
            throw new HyperException(error);
        }
        return schemaHandle;
    }

    public static final class Column {
        private Name name;
        private SqlType type;
        private Nullability nullability;
        private String collation;

        public Column(Name columnName, SqlType type, String collation, Nullability nullability) {
            this.name = columnName;
            this.type = type;
            this.nullability = nullability;
            this.collation = collation;
            TypeTag tag = type.getTag();
            if (!collation.isEmpty() && tag != TypeTag.TEXT && tag != TypeTag.VARCHAR && tag != TypeTag.CHAR) {
                throw new IllegalArgumentException("Collation is not supported for data type " + (Object)((Object)tag) + ".");
            }
        }

        public Column(String columnName, SqlType type, String collation, Nullability nullability) {
            this(new Name(columnName), type, collation, nullability);
        }

        public Column(String columnName, SqlType type, String collation) {
            this(new Name(columnName), type, collation);
        }

        public Column(Name columnName, SqlType type, String collation) {
            this(columnName, type, collation, Nullability.NULLABLE);
        }

        public Column(String columnName, SqlType type, Nullability nullability) {
            this(new Name(columnName), type, nullability);
        }

        public Column(Name columnName, SqlType type, Nullability nullability) {
            this(columnName, type, "", nullability);
        }

        public Column(String columnName, SqlType type) {
            this(new Name(columnName), type);
        }

        public Column(Name columnName, SqlType type) {
            this(columnName, type, "", Nullability.NULLABLE);
        }

        public Name getName() {
            return this.name;
        }

        public SqlType getType() {
            return this.type;
        }

        public Nullability getNullability() {
            return this.nullability;
        }

        public String getCollation() {
            return this.collation;
        }
    }
}

