/*
 * Decompiled with CFR 0.152.
 */
package com.tableau.hyperapi;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import com.tableau.hyperapi.Connection;
import com.tableau.hyperapi.HyperAPI;
import com.tableau.hyperapi.Name;
import com.tableau.hyperapi.NativeHandleHelpers;
import com.tableau.hyperapi.SchemaName;
import com.tableau.hyperapi.TableDefinition;
import com.tableau.hyperapi.TableName;
import com.tableau.hyperapi.impl.BoolByReference;
import java.util.ArrayList;
import java.util.List;

public final class Catalog {
    private Connection connection;

    Catalog(Connection connection) {
        this.connection = connection;
    }

    public boolean hasTable(TableName tableName) {
        BoolByReference existsByRef = new BoolByReference();
        Pointer error = HyperAPI.hyper_has_table(this.connection.handle(), tableName.getDatabaseNameOrNull(), tableName.getSchemaNameOrNull(), tableName.getName().getUnescaped(), existsByRef);
        NativeHandleHelpers.throwHyperExceptionOnError(error);
        return existsByRef.getValue();
    }

    public TableDefinition getTableDefinition(TableName tableName) {
        Pointer tableHandle = this.getNativeTableDefinitionHandleForName(tableName);
        TableDefinition result = TableDefinition.constructFromNativeHandle(tableHandle);
        HyperAPI.hyper_destroy_table_definition(tableHandle);
        return result;
    }

    public void createTable(TableDefinition tableDefinition) {
        this.createTableInternal(tableDefinition, true);
    }

    public void createTableIfNotExists(TableDefinition tableDefinition) {
        this.createTableInternal(tableDefinition, false);
    }

    private void createTableInternal(TableDefinition schema, boolean failIfExists) {
        this.connection.throwIfClosed();
        Pointer schemaHandle = schema.createNativeTableDefinition();
        Pointer error = HyperAPI.hyper_create_table(this.connection.handle(), schemaHandle, failIfExists);
        HyperAPI.hyper_destroy_table_definition(schemaHandle);
        NativeHandleHelpers.throwHyperExceptionOnError(error);
    }

    List<Name> convertStringList(Pointer stringList) {
        int size = HyperAPI.hyper_string_list_size(stringList);
        assert (size >= 0);
        ArrayList<Name> result = new ArrayList<Name>(size);
        for (int i = 0; i != size; ++i) {
            result.add(new Name(HyperAPI.hyper_string_list_at(stringList, i)));
        }
        HyperAPI.hyper_string_list_destroy(stringList);
        return result;
    }

    public void createSchema(SchemaName schema) {
        this.createSchemaInternal(schema, true);
    }

    public void createSchemaIfNotExists(SchemaName schema) {
        this.createSchemaInternal(schema, false);
    }

    private void createSchemaInternal(SchemaName schema, boolean failIfExists) {
        this.connection.throwIfClosed();
        Pointer error = HyperAPI.hyper_create_schema(this.connection.handle(), schema.getDatabaseNameOrNull(), schema.getName().getUnescaped(), failIfExists);
        NativeHandleHelpers.throwHyperExceptionOnError(error);
    }

    public List<SchemaName> getSchemaNames() {
        return this.getSchemaNames(null);
    }

    public List<SchemaName> getSchemaNames(Name database) {
        PointerByReference stringListRef = new PointerByReference();
        Pointer error = HyperAPI.hyper_get_schema_names(this.connection.handle(), database == null ? null : database.getUnescaped(), stringListRef);
        NativeHandleHelpers.throwHyperExceptionOnError(error);
        List<Name> unqualifiedNames = this.convertStringList(stringListRef.getValue());
        ArrayList<SchemaName> qualifiedNames = new ArrayList<SchemaName>(unqualifiedNames.size());
        for (Name name : unqualifiedNames) {
            qualifiedNames.add(new SchemaName(database, name));
        }
        return qualifiedNames;
    }

    public List<TableName> getTableNames(SchemaName schema) {
        PointerByReference stringListRef = new PointerByReference();
        Pointer error = HyperAPI.hyper_get_table_names(this.connection.handle(), schema.getDatabaseNameOrNull(), schema.getName().getUnescaped(), stringListRef);
        NativeHandleHelpers.throwHyperExceptionOnError(error);
        List<Name> unqualifiedNames = this.convertStringList(stringListRef.getValue());
        ArrayList<TableName> qualifiedNames = new ArrayList<TableName>(unqualifiedNames.size());
        for (Name name : unqualifiedNames) {
            qualifiedNames.add(new TableName(schema, name));
        }
        return qualifiedNames;
    }

    public void createDatabase(String databasePath) {
        this.createDatabaseInternal(databasePath, true);
    }

    public void createDatabaseIfNotExists(String databasePath) {
        this.createDatabaseInternal(databasePath, false);
    }

    private void createDatabaseInternal(String path, boolean failIfExists) {
        Pointer error = HyperAPI.hyper_create_database(this.connection.handle(), path, failIfExists);
        NativeHandleHelpers.throwHyperExceptionOnError(error);
    }

    public void attachDatabase(String databasePath) {
        Pointer error = HyperAPI.hyper_attach_database(this.connection.handle(), databasePath, null);
        NativeHandleHelpers.throwHyperExceptionOnError(error);
    }

    public void attachDatabase(String databasePath, Name databaseAlias) {
        Pointer error = HyperAPI.hyper_attach_database(this.connection.handle(), databasePath, databaseAlias.getUnescaped());
        NativeHandleHelpers.throwHyperExceptionOnError(error);
    }

    public void detachDatabase(Name databaseAlias) {
        Pointer error = HyperAPI.hyper_detach_database(this.connection.handle(), databaseAlias.getUnescaped());
        NativeHandleHelpers.throwHyperExceptionOnError(error);
    }

    public void detachAllDatabases() {
        Pointer error = HyperAPI.hyper_detach_all_databases(this.connection.handle());
        NativeHandleHelpers.throwHyperExceptionOnError(error);
    }

    public void dropDatabase(String databasePath) {
        this.dropDatabaseInternal(databasePath, true);
    }

    public void dropDatabaseIfExists(String databasePath) {
        this.dropDatabaseInternal(databasePath, false);
    }

    private void dropDatabaseInternal(String databasePath, boolean failIfNotExists) {
        Pointer error = HyperAPI.hyper_drop_database(this.connection.handle(), databasePath, failIfNotExists);
        NativeHandleHelpers.throwHyperExceptionOnError(error);
    }

    public Connection getConnection() {
        this.connection.throwIfClosed();
        return this.connection;
    }

    private Pointer getNativeTableDefinitionHandleForName(TableName table) {
        PointerByReference schemaHandleRef = new PointerByReference();
        Pointer error = HyperAPI.hyper_get_table_definition(this.connection.handle(), table.getDatabaseNameOrNull(), table.getSchemaNameOrNull(), table.getName().getUnescaped(), schemaHandleRef);
        NativeHandleHelpers.throwHyperExceptionOnError(error);
        return schemaHandleRef.getValue();
    }
}

